document.addEventListener('DOMContentLoaded', function() {
    // Handle Brand Form Submission
    const addBrandForm = document.getElementById('addBrandForm');
    if (addBrandForm) {
        addBrandForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const brandName = this.querySelector('[name="brand_name"]').value;
            
            fetch('add_brand.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/x-www-form-urlencoded',
                },
                body: `brand_name=${encodeURIComponent(brandName)}`
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const brandSelect = document.getElementById('brand-select');
                    const option = document.createElement('option');
                    option.value = data.brand_id;
                    option.textContent = brandName;
                    brandSelect.appendChild(option);
                    
                    // Close modal and reset form
                    bootstrap.Modal.getInstance(document.getElementById('addBrandModal')).hide();
                    addBrandForm.reset();
                }
            });
        });
    }

    // Handle Model Form Submission
    const addModelForm = document.getElementById('addModelForm');
    if (addModelForm) {
        addModelForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = new FormData(this);
            
            fetch('add_model.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    const modelSelect = document.getElementById('model-select');
                    if (formData.get('brand_id') === document.getElementById('brand-select').value) {
                        const option = document.createElement('option');
                        option.value = data.model_id;
                        option.textContent = formData.get('model_name');
                        modelSelect.appendChild(option);
                    }
                    
                    // Close modal and reset form
                    bootstrap.Modal.getInstance(document.getElementById('addModelModal')).hide();
                    addModelForm.reset();
                }
            });
        });
    }

    // Sidebar toggle
    const sidebarToggle = document.getElementById('sidebarCollapse');
    const sidebar = document.getElementById('sidebar');
    const content = document.getElementById('content');

    if (sidebarToggle) {
        sidebarToggle.addEventListener('click', function() {
            sidebar.classList.toggle('active');
            content.classList.toggle('active');
        });
    }

    // Close sidebar on mobile when clicking outside
    document.addEventListener('click', function(e) {
        if (window.innerWidth <= 768) {
            if (!sidebar.contains(e.target) && !sidebarToggle.contains(e.target)) {
                sidebar.classList.remove('active');
                content.classList.remove('active');
            }
        }
    });
}); 